#pragma once

#include "TextEdit_CLine.h"

extern void SysMsg_Set(const char *pstr); // from skk.cpp

enum EFilenameType {EFT_Overwrite,EFT_SaveAs,EFT_NewFilename};

extern bool TextEdit_ChangedFlag;

extern void TextEdit_Init(void);
extern void TextEdit_Free(void);
extern void TextEdit_CheckLinkStructure(void);
extern void TextEdit_LoadFromFile(void);
extern void TextEdit_SaveToFile(EFilenameType FilenameType,const UnicodeChar *pNewFilename);
extern void TextEdit_Add(const UnicodeChar *pstr);
extern bool TextEdit_MoveCursor(u32 keys);
extern bool TextEdit_AddEnter(void);
extern bool TextEdit_Space(void);
extern bool TextEdit_Del(void);
extern void TextEdit_Draw(CglCanvas *pcan,bool DrawCursorFlag);
extern u32 TextEdit_GetCursorPosition(void);

extern void TextEdit_DrawCursorLine(CglCanvas *pcan,const u32 top,const bool DrawCursorFlag);

extern const CTextEditLine* TextEdit_GetTopLine(void);

extern void TextEdit_ClearAllLineState(void);

extern void TextEdit_Clipboard_Init(void);
extern void TextEdit_Clipboard_Free(void);

extern void TextEdit_SelectStart(void);
extern void TextEdit_SelectVSyncUpdate(void);
extern bool TextEdit_SelectCancel(void);
extern void TextEdit_SelectEnd(void);
